﻿using System;
using System.Collections;
using System.Web.UI;
using Soneta.Kadry;
using Soneta.Business;
using Soneta.Types;
using Soneta.Tools;
using Soneta.Kasa;
using Soneta.Kalend;
using Soneta.Web.Business.App;
using Soneta.Web.Business.Kadry;
using System.Collections.Generic;

namespace ASP {

    public partial class Ewidencja_Czasu_Pracy : System.Web.UI.Page {

        public string Str_CultureInfo = "pl-PL";
        public string Str_OkresAll = "(wszystko)";

        public class Params : ContextBase {

	        public Params(Context context) : base(context) {
		        Date data = ((ActualDate)Context[typeof(ActualDate)]).Actual;
		        okres = new YearMonth(data).ToFromTo();
	        }

	        FromTo okres;
	        [Soneta.Business.Required]
	        [Caption("Raport za okres")]
	        [Priority(1)]
	        public FromTo Okres {
		        get { return okres; }
		        set {
                    if (value == FromTo.Empty)
                        value = FromTo.All;
			        okres = value;
			        OnChanged(EventArgs.Empty);
		        }
	        }

	        bool wydziały = true;
	        [Priority(2)]
	        [Caption("Wydziały")]
	        public bool Wydziały {
		        get { return wydziały; }
		        set {
			        wydziały = value;
			        OnChanged(EventArgs.Empty);
		        }
	        }

	        bool pomińZerowe = true;
	        [Priority(3)]
	        [Caption("Pomiń zerowe")]
	        public bool PomińZerowe {
		        get { return pomińZerowe; }
		        set {
			        pomińZerowe = value;
			        OnChanged(EventArgs.Empty);
		        }
	        }
        }

        Params pars;
        [Context]
        public Params Pars {
	        get { return pars; }
	        set { pars = value; }
        }

        class Total : IComparable {

	        readonly Wydzial wydzial;
	        readonly FromTo okres;
	        readonly ArrayList pracownicy = new ArrayList();

	        public Total(Wydzial wydzial, FromTo okres) {
		        this.wydzial = wydzial;
		        this.okres = okres;
	        }

	        public Wydzial Wydzial {
		        get { return wydzial; }
	        }

	        public FromTo Okres {
		        get { return okres; }
	        }

            public string OkresStr {
                get { return okres.ToString(); }
            }
            
            public ArrayList Lista {
		        get { return pracownicy; }
	        }

	        public int CompareTo(object obj) {
		        if (obj == null)
			        return 1;
		        return wydzial.Nazwa.CompareTo(((Total)obj).Wydzial.Nazwa);
	        }
        }

        protected void OnContextLoad(Object sender, EventArgs e) {
	        // Odczytanie listy pracowników podległych z kontekstu
	        // Metoda znajduje się we wspólnej klasie dla strony raportu
	        // Soneta.Web.UI.ReportCorePage
            Row[] rows = getRows();

	        Date data = ((ActualDate)dc[typeof(ActualDate)]).Actual;
	        Hashtable ht = new Hashtable();
	        Wydzial firma = KadryModule.GetInstance(dc).Wydzialy.Firma;

            ReportHeader1["OKRES"] = (pars.Okres != FromTo.All) ? pars.Okres.ToString() : Str_OkresAll;

            foreach (Pracownik prc in rows) {
		        PracHistoria ph = prc[data];
		        Wydzial w = ph.Etat.Wydzial;
		        if (w != null) {
			        if (!pars.Wydziały)
				        w = firma;
			        Total t = (Total)ht[w];
			        if (t == null) {
				        t = new Total(w, pars.Okres);
				        ht.Add(w, t);
			        }
			        t.Lista.Add(ph);
		        }
	        }

	        ArrayList totals = new ArrayList(ht.Values);
	        totals.Sort();
	        DataRepeater1.DataSource = totals;
        }

        protected void Grid1_BeforeRow(Object sender, Soneta.Web.RowEventArgs args) {
	        PracHistoria ph = (PracHistoria)args.Row;
	        KalkulatorPracy kalk = new KalkulatorPracy(ph.Pracownik, null);
	        int[] d = new int[10];
	        int sd = 0;
	        foreach (OkresNieobecności n in kalk.Nieobecnosci(pars.Okres, true)) {
		        int i = n.Norma().Dni;
		        if (i > 0) {
			        sd += i;
			        switch (n.Definicja.Przyczyna) {
				        case PrzyczynaNieobecnosci.UrlopWypoczynkowy:
					        d[0] += i; break;
				        case PrzyczynaNieobecnosci.UrlopBezpłatny:
					        d[1] += i; break;
				        case PrzyczynaNieobecnosci.UrlopOkolicznościowy:
					        d[4] += i; break;
				        case PrzyczynaNieobecnosci.ZwolnienieChorobowe:
					        d[5] += i; break;
				        case PrzyczynaNieobecnosci.UrlopMacierzyński:
					        d[6] += i; break;
				        case PrzyczynaNieobecnosci.UrlopOpiekuńczy:
					        d[7] += i; break;
				        case PrzyczynaNieobecnosci.UrlopWychowawczy:
					        d[8] += i; break;
				        default:
					        switch (n.Definicja.Nazwa) {
						        case "Urlop szkoleniowy":
							        d[2] += i; break;
						        case "Urlop opiekuńczy (art 188 kp)":
							        d[3] += i; break;
						        default:
							        d[9] += i; break;
					        }
					        break;
			        }
		        }
	        }

	        if (sd == 0 && pars.PomińZerowe)
		        args.VisibleRow = false;
	        else {
		        wypoczynkowy.EditValue = d[0];
		        bezplatny.EditValue = d[1];
		        szkoleniowy.EditValue = d[2];
		        opieka.EditValue = d[3];
		        okolicz.EditValue = d[4];
		        zwollek.EditValue = d[5];
		        zmacierz.EditValue = d[6];
		        zopiek.EditValue = d[7];
		        wychow.EditValue = d[8];
		        inne.EditValue = d[9];
		        razem.EditValue = sd;
	        }
        }

        private Row[] getRows() {
            //Soneta.Business.View v = Soneta.Web.Business.Kadry.Tools.GetPodwładni(dc);
            var podwladni = KadryModule.GetInstance(dc.Context).Pracownicy.CreateView();
            Soneta.KadryPlace.Kadry.KalkulatorPodwladnych kalkulator = new Soneta.KadryPlace.Kadry.KalkulatorPodwladnych(dc.Context.Session, dc.Context.Session.Login.WebUserInstance.Host.ID);
            podwladni.Condition &= kalkulator.FiltrPodległości(pars.Okres, false);
            List<Pracownik> list = new List<Pracownik>();
            foreach (Pracownik p in podwladni)
                list.Add(p);
            return list.ToArray();
        }
    }
}
